﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace CRR_Example_Client
{
	public class IdNamePair
	{
		public int id { get; set; }
		public string name { get; set; }
		public override string ToString() { return name; }

		public IdNamePair(int id, string name)
		{
			this.id = id;
			this.name = name;
		}
	}

	public enum ProtocolType
	{
		HTTP,
		HTTPS,
	}

	public static class Misc
    {
		public static string ByteArrayToHEX(byte[] in_data)
        {
			return BitConverter.ToString(in_data).Replace("-", "");
		}

		public static byte[] HEXToByteArray(string in_data)
        {
			string data = in_data.Replace('a', 'A').Replace('b', 'B').Replace('c', 'C').Replace('d', 'D').Replace('e', 'E').Replace('f', 'F');
			Regex rgx = new Regex("[^A-F0-9]");
			data = rgx.Replace(data, "");
			if (data.Length % 2 == 1) data = String.Concat("0", data);

			List<byte> result = new List<byte>();

			for (int i = 0; i < data.Length; i += 2)
            {
				byte b = 0;
				if (Byte.TryParse(data.Substring(i, 2), NumberStyles.HexNumber, CultureInfo.InvariantCulture, out b)) result.Add(b);
			}

			return result.ToArray();
		}
    }
}
